/*
	File:		Offscreen.h

	Contains:	Class to help with offscreen drawing.

	Version:	Appearance 1.0 SDK

	Copyright:	 1997 by Apple Computer, Inc., all rights reserved.

	File Ownership:

		DRI:				Edward Voas

		Other Contact:		7 of 9, Borg Collective

		Technology:			OS Technologies Group

	Writers:

		(edv)	Ed Voas

	Change History (most recent first):

		 <1>	 9/11/97	edv		First checked in.
*/

#pragma once

#include <QDOffscreen.h>

class Offscreen
{
	public:
			Offscreen();
		virtual ~Offscreen();
	
		virtual void		StartDrawing( const Rect& bounds, Boolean copyDest = false );
		virtual void		EndDrawing();
		virtual void		EndDrawingAndBlend( const RGBColor& opColor );
		
	private:
		GWorldPtr	fWorld;
		CGrafPtr	fSavePort;
		GDHandle	fSaveDevice;
		Rect		fBounds;
};
